<?php
require_once "db.php";
 
/*    ELIMINAR PRODUCTO */
 
if (isset($_GET["eliminar"])) {
    $id = (int) $_GET["eliminar"];
    $conexion->query("DELETE FROM lista_compra WHERE id = $id");
    header("Location: index.php");
    exit;
}
 
 /*   MARCAR / DESMARCAR COMO COMPRADO */
 
if (isset($_GET["toggle"])) {
    $id = (int) $_GET["toggle"];
    // Obtener el estado actual
    $res = $conexion->query("SELECT comprado FROM lista_compra WHERE id=$id");
    $fila = $res->fetch_assoc();
    $nuevo = $fila["comprado"] ? 0 : 1;
    $conexion->query("UPDATE lista_compra SET comprado=$nuevo WHERE id=$id");
    header("Location: index.php");
    exit;
}

  /*  AGREGAR PRODUCTO */

if (isset($_POST["agregar"])) {
    $producto = trim($_POST["producto"]);
    $tienda   = trim($_POST["tienda"]);

    if ($producto && $tienda) {
        $stmt = $conexion->prepare(
            "INSERT INTO lista_compra (productos, tiendas, comprado) VALUES (?, ?, 0)"
        );
        $stmt->bind_param("ss", $producto, $tienda);
        $stmt->execute();
    }
}

  /*  BUSCAR PRODUCTO */

$buscar = $_GET["buscar"] ?? "";
$stmt = $conexion->prepare(
    "SELECT id, productos, tiendas, comprado 
     FROM lista_compra
     WHERE productos LIKE ? OR tiendas LIKE ?
     ORDER BY tiendas, productos"
);
$like = "%$buscar%";
$stmt->bind_param("ss", $like, $like);
$stmt->execute();
$resultado = $stmt->get_result();


  /*  ORGANIZAR POR TIENDA */

$listado = [];
while ($fila = $resultado->fetch_assoc()) {
    $tienda = $fila["tiendas"];
    $listado[$tienda][] = $fila;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="style.css">
    <title>Lista de la Compra</title>

</head>

<body>

    <h2>🛒 Lista de la Compra</h2>
   <div class="nuevo">
    <h3>➕ Agregar producto</h3>

    <form method="post" id="formProducto">
        <input type="text" id="producto" name="producto" placeholder="Producto" required>
        <input type="text" id="tienda" name="tienda" placeholder="Tienda" required>

        <button class="agregar" name="agregar">Agregar</button>
        <button type="button" onclick="iniciarVoz()" style="margin-top:8px;">
            🎤 Añadir por Vozarron
        </button>
    </form>
</div>


    <form class="buscar" method="get">
        <input type="search" name="buscar" placeholder="Buscar producto o tienda"
            value="<?= htmlspecialchars($buscar) ?>">
    </form>


    <?php foreach ($listado as $tienda => $productos): ?>
        <div class="tienda">
            <h3><?= htmlspecialchars($tienda) ?></h3>
            <?php foreach ($productos as $p): ?>
                <div class="producto">
                    <span class="<?= $p['comprado'] ? 'comprado' : '' ?>">
                        <?= htmlspecialchars($p['productos']) ?>
                    </span>
                    <div style="display:flex; gap:6px;">
                        <form method="get" style="margin:0;">
                            <input type="hidden" name="toggle" value="<?= $p['id'] ?>">
                            <button class="comprar" type="submit">
                                <?= $p['comprado'] ? 'Desmarcar' : '✔' ?>
                            </button>
                        </form>
                        <form method="get" style="margin:0;">
                            <input type="hidden" name="eliminar" value="<?= $p['id'] ?>">
                            <button class="eliminar" type="submit"
                                onclick="return confirm('¿Eliminar este producto?');">
                                🗑
                            </button>
                        </form>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php endforeach; ?>
<script>
function iniciarVoz() {
    if (!('webkitSpeechRecognition' in window)) {
        alert("Tu navegador no soporta reconocimiento de voz");
        return;
    }

    const recognition = new webkitSpeechRecognition();
    recognition.lang = "es-ES";
    recognition.interimResults = false;

    recognition.start();

    recognition.onresult = function(event) {
        const texto = event.results[0][0].transcript.trim();
        const palabras = texto.split(" ");

        // Primera palabra → producto
        document.getElementById("producto").value = palabras.shift();

        // Resto → tienda
        document.getElementById("tienda").value = palabras.join(" ");
    };

    recognition.onerror = function() {
        alert("Error al reconocer la voz");
    };
}
</script>

</body>

</html>